#include <View.h>
#include "MyBYAddon.h"


MyBYAddon::MyBYAddon()
	: BYAddon()
{
	
}


MyBYAddon::~MyBYAddon()
{
}


// instantiate the view for the tab
BView * MyBYAddon::CreateView(BRect *bounds)
{
	//The background
	BView *bg = new BView(*bounds, "a view", B_FOLLOW_ALL, B_WILL_DRAW);
	bg->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	//The "Wireless" box
	BBox *wireless = new BBox(BRect(4, 12, 400, 276), "wireless");
	wireless->SetLabel("Wireless");
	bg->AddChild(wireless);
	
	//The "Mode" pop-up menu
	modes = new BPopUpMenu("modes", true, true);	
	bss = new BMenuItem("BSS", NULL);
	ibss = new BMenuItem("IBSS", NULL);
	modes->AddItem(bss);
	modes->AddItem(ibss);
	
	//The "Mode" drop-down
	mode_list = new BMenuField(BRect(10, 15, 288, 20), "mode_list", "Mode:", modes);
	bss->SetMarked(true);
	wireless->AddChild(mode_list);

	//The "Channel" pop-up menu
	channels = new BPopUpMenu("channels", true, true);	
	c01 = new BMenuItem("1", NULL);
	c02 = new BMenuItem("2", NULL);
	c03 = new BMenuItem("3", NULL);
	c04 = new BMenuItem("4", NULL);
	c05 = new BMenuItem("5", NULL);
	c06 = new BMenuItem("6", NULL);
	c07 = new BMenuItem("7", NULL);
	c08 = new BMenuItem("8", NULL);
	c09 = new BMenuItem("9", NULL);
	c10 = new BMenuItem("10", NULL);
	c11 = new BMenuItem("11", NULL);
	c12 = new BMenuItem("12", NULL);
	c13 = new BMenuItem("13", NULL);
	c14 = new BMenuItem("14", NULL);
	channels->AddItem(c01);
	channels->AddItem(c02);
	channels->AddItem(c03);
	channels->AddItem(c04);
	channels->AddItem(c05);
	channels->AddItem(c06);
	channels->AddItem(c07);
	channels->AddItem(c08);
	channels->AddItem(c09);
	channels->AddItem(c10);
	channels->AddItem(c11);
	channels->AddItem(c12);
	channels->AddItem(c13);
	channels->AddItem(c14);
	
	//The "Channel" drop-down
	channel_list = new BMenuField(BRect(10, 40, 288, 20), "channel_list", "Channel:", channels);
	c01->SetMarked(true);
	wireless->AddChild(channel_list);

	//The "SSID" text-control
	add_ssid = new BTextControl(BRect(10, 67, 283, 20), "add_ssid", "Network name (SSID):", NULL,  NULL);
	add_ssid->MakeFocus(true);
	wireless->AddChild(add_ssid);
	
	//The "Privacy" pop-up
	privacy = new BPopUpMenu("privacy", true, true);
	noprivacy = new BMenuItem("No privacy", new BMessage(WPS_NOPRIVACY));
	wep64 = new BMenuItem("WEP 64 bits", new BMessage(WPS_64PRIVACY));
	wep128 = new BMenuItem("WEP 128 bits", new BMessage(WPS_128PRIVACY));
	privacy->AddItem(noprivacy);
	privacy->AddItem(wep64);
	privacy->AddItem(wep128);

	//The "Privacy" drop-down
	privacy_list = new BMenuField(BRect(10, 100, 288, 20), "privacy", "Privacy:", privacy);
	noprivacy->SetMarked(true);
	wireless->AddChild(privacy_list);
	
	//The "Key0" text-control
	key0 = new BTextControl(BRect(10, 129, 282, 20), "key0", "WEP Key 0:", NULL,  NULL);
	key0->MakeFocus(true);
	key0->SetEnabled(false);
	wireless->AddChild(key0);

	//The "Key1" text-control
	key1 = new BTextControl(BRect(10, 153, 282, 20), "key1", "WEP Key 1:", NULL,  NULL);
	key1->MakeFocus(true);
	key1->SetEnabled(false);
	wireless->AddChild(key1);

	//The "Key2" text-control
	key2 = new BTextControl(BRect(10, 177, 282, 20), "key2", "WEP Key 2:", NULL,  NULL);
	key2->MakeFocus(true);
	key2->SetEnabled(false);
	wireless->AddChild(key2);

	//The "Key3" text-control
	key3 = new BTextControl(BRect(10, 201, 282, 20), "key3", "WEP Key 3:", NULL,  NULL);
	key3->MakeFocus(true);
	key3->SetEnabled(false);
	wireless->AddChild(key3);
	
	//The "About" box
	BBox *about = new BBox(BRect(4, 239, 400, 276), "about");
	about->SetLabel("About");
	about->SetFont(be_plain_font);
	bg->AddChild(about);

	//The about text
	BStringView *about_text = new BStringView(BRect(10, 10, 400, 28), "about_text", "Developed by PetterHJ with help from mmu_man's Boneyard addon skeleton");
	about->AddChild(about_text);

	LoadSettings();
	
	////////////////////////////////////////
	//////////TEMP/////////////////////////
	//////////////////////////////////////
	
	key0->SetEnabled(true);
	key1->SetEnabled(true);
	key2->SetEnabled(true);
	key3->SetEnabled(true);

	return bg;
}


// Messages
void MyBYAddon::MessageReceived(BMessage *msg)
{
	switch (msg->what) 
	{
		case WPS_NOPRIVACY:
			//Enables and disables different controls
			key0->SetEnabled(false);
			key1->SetEnabled(false);
			key2->SetEnabled(false);
			key3->SetEnabled(false);
			printf("No");
			break;
			
		case WPS_64PRIVACY:
			//Enables and disables different controls
			key0->SetEnabled(true);
			key1->SetEnabled(true);
			key2->SetEnabled(true);
			key3->SetEnabled(true);
			printf("64");
			break;
			
		case WPS_128PRIVACY:
			//Enables and disables different controls
			key0->SetEnabled(true);
			key1->SetEnabled(true);
			key2->SetEnabled(true);
			key3->SetEnabled(true);
			printf("128");
			break;
	}
}


// LoadSettings
bool MyBYAddon::LoadSettings()
{
	//Read info from the hfa384x_cs config file
	FILE *fp;
	fp = fopen("/boot/home/config/settings/kernel/drivers/hfa384x_cs","r");
	if(fp)
	{
		char line[1000];
		char line2[1000];
		char line3[1000];
		char line4[1000];
		char line5[1000];
		char line6[1000];
		char line7[1000];
		char line8[1000];
		fgets(line, 1000, fp);
		fgets(line2, 1000, fp);
		fgets(line3, 1000, fp);
		fgets(line4, 1000, fp);
		fgets(line5, 1000, fp);
		fgets(line6, 1000, fp);
		fgets(line7, 1000, fp);
		fgets(line8, 1000, fp);

		char * fmode;
		char * fmode2;
		fmode = strtok(line, "\t");
		fmode2 = strtok(NULL, "\t");
		
		char * fchannel;
		char * fchannel2;
		fchannel = strtok(line2, "\t");
		fchannel2 = strtok(NULL, "\t");
		
		char * fssid;
		char * fssid2;
		fssid = strtok(line3, "\t");
		fssid2 = strtok(NULL, "\t");

		char * fprivacy;
		char * fprivacy2;
		fprivacy = strtok(line4, "\t");
		fprivacy2 = strtok(NULL, "\t");

		char * fkey0;
		char * fkey02;
		fkey0 = strtok(line5, "\t");
		fkey02 = strtok(NULL, "\t");

		char * fkey1;
		char * fkey12;
		fkey1 = strtok(line6, "\t");
		fkey12 = strtok(NULL, "\t");

		char * fkey2;
		char * fkey22;
		fkey2 = strtok(line7, "\t");
		fkey22 = strtok(NULL, "\t");
		
		char * fkey3;
		char * fkey32;
		fkey3 = strtok(line8, "\t");
		fkey32 = strtok(NULL, "\t");
		
		//Puts the info into the controls
		if(strstr(fmode2, "0"))
		{
			ibss->SetMarked(true);
		}
		if(strstr(fmode2, "1"))
		{
			bss->SetMarked(true);
		}
		
		if(strstr(fchannel2, "1"))
		{
			c01->SetMarked(true);
		}
		if(strstr(fchannel2, "2"))
		{
			c02->SetMarked(true);
		}
		if(strstr(fchannel2, "3"))
		{
			c03->SetMarked(true);
		}
		if(strstr(fchannel2, "4"))
		{
			c04->SetMarked(true);
		}
		if(strstr(fchannel2, "5"))
		{
			c05->SetMarked(true);
		}
		if(strstr(fchannel2, "6"))
		{
			c06->SetMarked(true);
		}
		if(strstr(fchannel2, "7"))
		{
			c07->SetMarked(true);
		}
		if(strstr(fchannel2, "8"))
		{
			c08->SetMarked(true);
		}
		if(strstr(fchannel2, "9"))
		{
			c09->SetMarked(true);
		}
		if(strstr(fchannel2, "10"))
		{
			c10->SetMarked(true);
		}
		if(strstr(fchannel2, "11"))
		{
			c11->SetMarked(true);
		}
		if(strstr(fchannel2, "12"))
		{
			c12->SetMarked(true);
		}
		if(strstr(fchannel2, "13"))
		{
			c13->SetMarked(true);
		}
		if(strstr(fchannel2, "14"))
		{
			c14->SetMarked(true);
		}
		
		if(strstr(fprivacy2, "0"))
		{
			noprivacy->SetMarked(true);
		}
		if(strstr(fprivacy2, "1"))
		{
			wep64->SetMarked(true);
		}
		if(strstr(fprivacy2, "2"))
		{
			wep128->SetMarked(true);
		}
		
		add_ssid->SetText(fssid2);
		
		key0->SetText(fkey02);
		key1->SetText(fkey12);
		key2->SetText(fkey22);
		key3->SetText(fkey32);
		
		fclose(fp);
	}
	if (!fp)
	{
		
	}

	return true;
}

// SaveSettings
bool MyBYAddon::SaveSettings()
{
	char *settingstext;
	settingstext = new char[256];

	FILE *hfa384xfile;
	hfa384xfile = fopen("/boot/home/config/settings/kernel/drivers/hfa384x_cs", "w");
	
	if(hfa384xfile)
	{	
		const char *mode_tf;
		const char *channel_tf;
		const char *ssid_tf;
		const char *privacy_tf;
		const char *key0_tf;
		const char *key1_tf;
		const char *key2_tf;
		const char *key3_tf;	

		int mode_value;			
		mode_value = mode_list->Menu()->IndexOf(mode_list->Menu()->FindMarked());

		if(mode_value == 0)
		{
			mode_tf = "1";
		}
		if(mode_value == 1)
		{
			mode_tf = "0";
		}

		channel_tf = channel_list->MenuItem()->Label();
	
		ssid_tf = add_ssid->Text();

		int privacy_value;			
		privacy_value = privacy_list->Menu()->IndexOf(privacy_list->Menu()->FindMarked());

		if(privacy_value == 0)
		{
			privacy_tf = "0";
		}
		if(privacy_value == 1)
		{
			privacy_tf = "1";
		}
		if(privacy_value == 2)
		{
			privacy_tf = "2";
		}
		
		key0_tf = key0->Text();
		key1_tf = key1->Text();
		key2_tf = key2->Text();
		key3_tf = key3->Text();
			
		//Writes the variables to the hfa384x_cs driver file
		strcpy(settingstext, "mode\t\t");
		strcat(settingstext, mode_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "channel\t\t");
		strcat(settingstext, channel_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "ssid\t\t");
		strcat(settingstext, ssid_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "privacy\t\t");
		strcat(settingstext, privacy_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "key0\t\t");
		strcat(settingstext, key0_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "key1\t\t");
		strcat(settingstext, key1_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "key2\t\t");
		strcat(settingstext, key2_tf);
		strcat(settingstext, "\t\n");
		
		strcat(settingstext, "key3\t\t");
		strcat(settingstext, key3_tf);
		strcat(settingstext, "\t\n");
		
		fputs(settingstext, hfa384xfile);
				
		fclose(hfa384xfile);
	}
	if(!hfa384xfile)
	{
		BAlert *alert = new BAlert("Warning", "Could not find the hfa384x settings file!", "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_WARNING_ALERT);
		alert->Go();		
	}

	return true;
}

// called when the user clicks the "Revert" button ?
void MyBYAddon::Revert()
{
	LoadSettings();
}

// called when the user clicks the "Save" button ?
void MyBYAddon::Save()
{
	SaveSettings();
}

// name for the tab
const char *
MyBYAddon::Name()
{
	return "Wireless";
}

// section name (for the config file)
const char * MyBYAddon::Section()
{
	return "Wireless";
}

// description (for the config file)
const char * MyBYAddon::Description()
{
	return "Wireless networking config";
}

// guess: the list the addon touches for the config (so that profiles can save them)
const BList * MyBYAddon::FileList()
{
	BList *l = new BList();
//	l->AddItem((void *)"/boot/home/config/settings/kernel/drivers/ne2k");
	return l;
}

// determine the position on the tab pane
int MyBYAddon::Importance()
{
	return BY_IMP_LOW;
}

// create the addon class and return it
BYAddon *instantiate(void)
{
	return (BYAddon *) new MyBYAddon();
}
